//=============================================================================
// Used for controlling vendors and getting pay afterwards.
//=============================================================================
class VendorKeeperGun extends DeusExWeapon;

var bool bNegMod;
var int XMode;
var int BeltSelector;
var int CostModAmount;
var localized string ModeMessages[4];
var MSVendor SelectedVendor;

simulated function bool TestMPBeltSpot(int BeltSpot)
{
   return (BeltSpot == 4);
}

function CycleAmmo()
{
 XMode++;
 if (XMode > 3)
  XMode = 0;
 
 Pawn(Owner).ClientMessage(ModeMessages[XMode]);
}

function LaserToggle()
{
if (XMode == 1)
{
if (!bNegMod)
{
 bNegMod = True;
 Pawn(Owner).ClientMessage("|p2You are now modifying costs with a negative amount!");
 return; 
}
else if (bNegMod)
{
 bNegMod = False;
 Pawn(Owner).ClientMessage("|p3You are now modifying costs with a positive amount!");
 return; 
}
}
}

function ScopeToggle()
{
 if (XMode == 1)
 {
  CostModAmount += 5;
  if (CostModAmount > 25)
   CostModAmount = 5;
  
  Pawn(Owner).ClientMessage("|p3You are now modifying button prices by the amount of "$CostModAmount$"!");
 }
  if (XMode == 2)
 {
  BeltSelector += 1;
  if (BeltSelector > 9)
   BeltSelector = 0;
  
  Pawn(Owner).ClientMessage("|p3You are now modifying button products with your belt slot item number "$BeltSelector$"!");
 }
 
}


function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
 local int VendorCost;
 local int otherbuttonnum;
 local pickup i;
 local DeusExPlayer P;

 if (XMode == 0)
 {
  if ((MSVendor(Other) != None) && (MSVendor(Other).Owner != Owner) && (MSVendor(Other).bOwnableVendor))
  {
   vendorcost = (MSVendor(Other).ItemCosts[0] + MSVendor(Other).ItemCosts[1] + MSVendor(Other).ItemCosts[2] + MSVendor(Other).ItemCosts[3] + MSVendor(Other).ItemCosts[4] + MSVendor(Other).ItemCosts[5] + MSVendor(Other).ItemCosts[6] + MSVendor(Other).ItemCosts[7]) * 2;

  if (SelectedVendor != MSVendor(Other))
  {
   SelectedVendor = MSVendor(Other);
   Pawn(Owner).ClientMessage("|p4This Vendor Costs "$vendorcost$" To Buy!");
   return;
  }
  else if (SelectedVendor == MSVendor(Other))
  {
   if (DeusExPlayer(Owner).Credits < vendorcost)
   {
    Pawn(Owner).ClientMessage("|p2Insufficient Credits To Purchase Vendor!");
    return;
   }
   SelectedVendor.SendMoneyToMarkus(vendorcost);
   SelectedVendor.SetOwner(Owner);
   SelectedVendor.SetPropertyText("Owner", ""$Owner$"");
   SelectedVendor.BenifactorName = Pawn(Owner).PlayerReplicationInfo.PlayerName;
   DeusExPlayer(Owner).Credits -= VendorCost;
   Pawn(Owner).ClientMessage("You have succesfully boughten the vendor!");
   SelectedVendor = None;
   return;
  }
  }
  else
   Pawn(Owner).ClientMessage("|p2ERROR: This is not a valid vendor!");  
 }
//--------------end of mode 1
//--------------mode 2
 if (XMode == 1)
 {
  if ((VendorButton(Other) != None) && (VendorButton(Other).Owner.Owner == Owner))
  {  
   OtherButtonNum = VendorButton(Other).ButtonNum;
  if (!bNegMod)
   MSVendor(Other.Owner).ItemCosts[OtherButtonNum - 1] += CostModAmount;
  else if (bNegMod)
   MSVendor(Other.Owner).ItemCosts[OtherButtonNum - 1] -= CostModAmount;
   
   Pawn(Owner).ClientMessage("|p3Vendor button "$OtherButtonNum$"'s cost is now "$MSVendor(Other.Owner).ItemCosts[OtherButtonNum -1]$" Dollars!");
   
  }
  else
   Pawn(Owner).ClientMessage("|p2ERROR: This is not a valid button, be sure you own it!");  
 }
//--------------end of mode 2
//--------------mode 3
 if (XMode == 2)
 {
  forEach AllActors(Class'Pickup', i)
  {
  //forEach AllActors(Class'DeusExPlayer', P)
  //{

  if ((VendorButton(Other) != None) && (VendorButton(Other).Vendor.Owner == Owner) && (i != None)  && (i.Owner == Owner)  && (i.beltPos == BeltSelector))
  {
   if ((i.Class != Class'FoodCard') && (i.Class != Class'StuffCard') && (i.Class != Class'WepCard') && (i.Class != Class'ClothesCard') && (i.Class != Class'PetCard') && (i.Class != Class'GadgetCard'))
   {
   OtherButtonNum = VendorButton(Other).ButtonNum;
   MSVendor(Other.Owner).DispensedItems[OtherButtonNum - 1] = i.class;
   Pawn(Owner).ClientMessage("|p3Vendor button "$OtherButtonNum$"'s cost is now dispensing "$MSVendor(Other.Owner).DispensedItems[OtherButtonNum -1]$"!");
   return;
   }
   else if ((i.Class == Class'FoodCard') || (i.Class == Class'StuffCard') || (i.Class == Class'WepCard') || (i.Class == Class'ClothesCard') || (i.Class == Class'PetCard') || (i.Class == Class'GadgetCard'))  
   {
    Pawn(Owner).ClientMessage("|p2Putting cards inside vending machines is not allowed!");
    return;
   }
  }
//  }
  }
 }
//--------------end of mode 3
//--------------mode 4
 if (XMode == 3)
 {
 if (Other.Owner == Owner)
 {
  if ((MSVendor(Other) != None) && (MSVendor(Other).Mass > 20))
  MSVendor(Other).Mass = 20;
  
 if (MSVendor(Other).bPushable)
 {
  MSVendor(Other).bPushable = False;
  Pawn(Owner).ClientMessage("|p4This Vendor has had its pushable property set to "$MSVendor(Other).bPushable$"!");
  return;
 }
 if (!MSVendor(Other).bPushable)
 {
  MSVendor(Other).bPushable = True;
  Pawn(Owner).ClientMessage("|p4This Vendor has had its pushable property set to "$MSVendor(Other).bPushable$"!");
  return;
 }
 }
  else
   P.ClientMessage("|p2ERROR: This is not one of your vendors!");
 }
}

state NormalFire
{
Begin:
	if ((ClipCount >= ReloadCount) && (ReloadCount != 0))
	{
		if (!bAutomatic)
		{
			bFiring = False;
			FinishAnim();
		}

		if (Owner != None)
		{
			if (Owner.IsA('DeusExPlayer'))
			{
				bFiring = False;


				// should we autoreload?
				if (DeusExPlayer(Owner).bAutoReload)
				{
					// auto switch ammo if we're out of ammo and
					// we're not using the primary ammo
					if ((AmmoType.AmmoAmount == 0) && (AmmoName != AmmoNames[0]))
						CycleAmmo();
					ReloadAmmo();
				}
				else
				{
					if (bHasMuzzleFlash)
						EraseMuzzleFlashTexture();
					GotoState('Idle');
				}
			}
			else if (Owner.IsA('ScriptedPawn'))
			{
				bFiring = False;
				ReloadAmmo();
			}
		}
		else
		{
			if (bHasMuzzleFlash)
				EraseMuzzleFlashTexture();
			GotoState('Idle');
		}
	}
	if ( bAutomatic && (( Level.NetMode == NM_DedicatedServer ) || ((Level.NetMode == NM_ListenServer) && Owner.IsA('DeusExPlayer') && !DeusExPlayer(Owner).PlayerIsListenClient())))
		GotoState('Idle');

	Sleep(GetShotTime());
	if (bAutomatic)
	{
		GenerateBullet();	// In multiplayer bullets are generated by the client which will let the server know when
		Goto('Begin');
	}
	bFiring = False;
	FinishAnim();

	ReadyToFire();
Done:
	bFiring = False;
	Finish();
}

defaultproperties
{
     LowAmmoWaterMark=0
     GoverningSkill=Class'DeusEx.SkillWeaponLowTech'
     NoiseLevel=0.050000
     EnemyEffective=ENMEFF_Organic
     Concealability=CONC_Visual
     reloadTime=0.000000
     maxRange=8192
     AccurateRange=4096
     BaseAccuracy=0.000000
     bHasMuzzleFlash=True
     bHandToHand=False
     bFallbackWeapon=True
     mpHitDamage=0
     mpBaseAccuracy=1.000000
     mpAccurateRange=4096
     mpMaxRange=8192
     AmmoName=Class'DeusEx.AmmoNone'
     ReloadCount=0
     bInstantHit=True
     FireOffset=(X=-5.000000,Y=8.000000,Z=14.000000)
     shakemag=20.000000
     FireSound=Sound'DeusExSounds.Weapons.PistolFire'
     SelectSound=Sound'DeusExSounds.Weapons.PistolSelect'
     InventoryGroup=243
     ItemName="|p3Vendor Owner's Gun"
     PlayerViewOffset=(X=22.000000,Y=-10.000000,Z=-14.000000)
     PlayerViewMesh=LodMesh'Glock'
     PickupViewMesh=LodMesh'GlockPickup'
     ThirdPersonMesh=LodMesh'Glock3rd'
     Icon=Texture'DeusExUI.Icons.BeltIconPistol'
     largeIcon=Texture'DeusExUI.Icons.LargeIconPistol'
     largeIconWidth=47
     largeIconHeight=44
     Description="If you are reading this than you are obviously not playing with other people..."
     beltDescription="|p3VEND GUN"
     Mesh=LodMesh'DeusExItems.GlockPickup'
     CollisionRadius=12.65
     CollisionHeight=0.800000
     HitDamage=0
     BeltSelector=1
     CostModAmount=5
     ModeMessages(0)="|p3Now buying vendors!"
     ModeMessages(1)="|p4Now Changing Item Prices!"
     ModeMessages(2)="|p7Now Changing Dispensed Items!"
     ModeMessages(3)="|p2Now Toggling Vendor's Pushability!"
}
